/*
 * Three_Reaction_Time_Games.c
 *
 * Created: 7/26/2021 12:26:47 PM
 *  Author: Mahmood Alimohammadi
 */ 

/*Description:Includes three games presented to measure the
the players' reaction times. Game 1 is designed for one player
having four chances for reaction by pushing play buttons
consecutively and stopping four up-counting counters at the 
appropriate time as fast as possible.
In Game2,two players can participate, each having two chances 
to press and stop two up-counting counters consecutively. 
In game3, two, three or four players can participate, each having 
access to one play button.The games and number of players are 
selectable.The instructions, results and name of the winner(s)are 
all displayed on the LCD screen.*/

//Micro: ATmega8A
#ifndef	F_CPU	4000000UL
#define F_CPU	4000000UL
#endif

#include <avr/io.h>
#include <util/delay.h>
#include <inttypes.h>
#include <avr/interrupt.h>
#include <stdlib.h> //used for pseudo random numbers
#include "lcd.h"
//-------------------------------------
//Start Timer1 at Fcpu /8 for the main counter
#define COUNTER1_ON TCCR1B |= (1 << CS11)
#define COUNTER1_OFF TCCR1B &= ~(1 << CS11)
// Start Timer2 at Fcpu /8 for toggling PIND7
#define SOUND_ON TCCR2 |= (1<<(CS21))
#define SOUND_OFF  TCCR2 &= ~(1<<(CS21))

#define GameSelector bit_is_clear(PINC,PC0)
#define Player1_Button bit_is_clear(PINC,PC1)
#define Player2_Button bit_is_clear(PINC,PC2)
#define Player3_Button bit_is_clear(PINC,PC3)
#define Player4_Button bit_is_clear(PINC,PC4)
#define Start bit_is_clear(PINC,PC5)
#define LED1_ON PORTB=0x01
#define LED1_OFF PORTB &= ~(0x01)
//-------------------------------------
//Function declarations
void game1();
void game1_count1_on();
void game1_display_results();
void game2();
void game2_count1_on();
void game2_display_results();
void game3();
void game3_counters_on_off();
void game3_display_results();
void game3_number_of_players();
void display_n_o_players();
void beep();
void game_restart();
void game_reset();
void LED_flash();

//Global variables
uint16_t main_counter,count1,count2,count3,count4;
uint16_t total_counts, total_counts2;
uint8_t start1,start2,start3,start4,step1,step2;
uint8_t selector=1,restart,game_selector_restart;
uint8_t game3_n_of_players=4,flash,random_number;
//Timer/Counter 1 Compare Match  Interrupt Service Routine
ISR(TIMER1_COMPA_vect);
//Timer/Counter 2 Interrupt Service Routine
ISR(TIMER2_OVF_vect);
//-------------------------------------
int main (void)
{
	//Configure PINB0 as output for LED1
	DDRB |= 1<<(0);
	PORTB &= ~(1<<(0));
	//Configure PORTC as input for 6 pushbuttons
	DDRC |=0x00;
	//Activate pull-ups
	PORTC |=0xff;
	// set PIND7 as output for piezo sounder
	DDRD |= 1<<(7);
	//-------------------------------------
	//SRAND(initial seed) of the random number generator
	TCCR0 |= (1 << CS01);
	//Configure Timer 1 for CTC mode
	TCCR1B |= (1 << WGM12);
	// Set CTC compare value to 1ms at 4MHz AVR clock
	//for the main counter of the circuit
	OCR1A=500-1;
	// Start Timer1 at Fcpu /8
	TCCR1B |=(1 << CS11);
	//Enable Timer/Counter1, Output Compare A Match Interrupt
	//Enable overflow interrupts of Timer2
	TIMSK = 1<<OCIE1A|1<<TOIE2;
	//Enable global interrupts
	sei();
	COUNTER1_OFF;
	//-------------------------------------
	LCD_init();
	LCD_goto(1,1);
	LCD_Text("Three Reaction Time");
	LCD_goto(2,10);
	LCD_Text("Games");
	_delay_ms(1000);
	LCD_Clear();
	
	LCD_goto(1,10);
	LCD_Text("Game 1");
	LCD_goto(2,10);
	LCD_Text("Player:1");
	LCD_goto(3,1);
	LCD_Text("Press Start Button");
	//Acknowledge power-on status
	SOUND_ON;
	_delay_ms(300);
	SOUND_OFF;
	//-------------------------------------
	while(1)
	{
		//GameSelector button for selecting game1, game2 or game3
		if(GameSelector)
		{
			selector++;
			if(selector>3)
			selector=1;
			game_selector_restart=1;
			//Acknowledge button press
			SOUND_ON;
			_delay_ms(300);
			SOUND_OFF;
		}
		switch(selector)
		{
			case 1: game1(); break;
			case 2: game2(); break;
			case 3: game3(); break;
		}
		//This function seeds the random number generator used by the function rand
		srand(TCNT0);	
	}
}
//------------------------------------
void game1()
{
	//while start button is pressed
	// or restart variable=1 or game_selector_restart=1
	while(Start || restart || game_selector_restart)
	{
		game_reset();
		step1=1;
		restart=0;
		game_selector_restart=0;
	}
	//maximum count of the main counter= 32004(8001*4=32004) milliseconds
	if(main_counter>32004)
	{
		main_counter=32004;
		LED1_OFF;
	}
	game1_count1_on();
	game1_display_results();
}
//-------------------------------------
void game1_count1_on()
{
	if(step1==1)
	{
		COUNTER1_ON;
		//Start count1
		count1=main_counter;
		if(count1>8001)
		{
			count1=8001;
			game_restart();
		}
		LCD_goto(1,1);
		LCD_Text("C1: ");
		LCD_Int(count1);
		LCD_goto(1,14);
		LCD_Text("Game 1");
		LCD_goto(3,15);
		LCD_Text("Sum:");
		total_counts=count1;
		LCD_goto(4,15);
		LCD_Int(total_counts);
	}
}
//------------------------------------
void game1_display_results()
{
	//Stop count1
	if(Player1_Button && step1==1 && count1<8001)
	{
		//Acknowledge button press
		beep();
		step1=2;
		
	}
	
	if(step1==2)
	{
		//Start count2
		count2=main_counter-count1;
		if(count2>8001)
		{
			count2=8001;
			game_restart();
		}
		LCD_goto(2,1);
		LCD_Text("C2: ");
		LCD_Int(count2);
		total_counts=count1+count2;
		LCD_goto(4,15);
		LCD_Int(total_counts);
	}
	//Stop count2
	if(Player2_Button && step1==2 && count2<8001)
	{
		//Acknowledge button press
		beep();
		step1=3;
	}
	
	if(step1==3)
	{
		//Start count3
		count3=main_counter-(count1+count2);
		if(count3>8001)
		{
			count3=8001;
			game_restart();
		}
		LCD_goto(3,1);
		LCD_Text("C3: ");
		
		LCD_Int(count3);
		total_counts=count1+count2+count3;
		LCD_goto(4,15);
		LCD_Int(total_counts);
	}
	//Stop count3
	if(Player3_Button && step1==3 && count3<8001)
	{
		//Acknowledge button press
		beep();
		step1=4;
	}
	
	if(step1==4)
	{
		//Start count4
		count4=main_counter-(count1+count2+count3);
		if(count4>8001)
		{
			count4=8001;
			game_restart();
		}
		LCD_goto(4,1);
		LCD_Text("C4: ");
		LCD_Int(count4);
		total_counts=count1+count2+count3+count4;
		LCD_goto(4,15);
		LCD_Int(total_counts);
	}
	//Stop count4 and reset the step1 variable
	if(Player4_Button && step1==4 && count4<8001)
	{
		//Acknowledge button press
		beep();
		step1=0;
		LED1_OFF;
	}
}
//------------------------------------
void game2()
{
	//while Start button is pressed, 
	//restart=1 or game_selector_restart=1
	while(Start || restart || game_selector_restart)
	{
		game_reset();
		step1=1;
		step2=3;
		restart=0;
		game_selector_restart=0;
	}
	//maximum count of the main counter= 16002(8001*2)milliseconds
	if(main_counter>16002)
	{
		main_counter=16002;
		LED1_OFF;
	}
	game2_count1_on();
	game2_display_results();
}
//-------------------------------------
void game2_count1_on()
{
	if(step1==1)
	{
		COUNTER1_ON;
		//Start count1 for player1
		count1=main_counter;
		if(count1>8001)
		{
			count1=8001;
			game_restart();
		}
		LCD_goto(1,1);
		LCD_Text("C1: ");
		LCD_Int(count1);
		LCD_goto(1,13);
		LCD_Text("C3: ");
		LCD_Int(count3);
		
		total_counts=count1;
		LCD_goto(3,1);
		LCD_Text("S1:");
		LCD_Int(total_counts);
	}
	
	if(step2==3)
	{
		COUNTER1_ON;
		//Start count3 for player2
		count3=main_counter;
		if(count3>8001)
		{
			count3=8001;
			game_restart();
		}
		LCD_goto(1,13);
		LCD_Text("C3: ");
		LCD_Int(count3);
		
		total_counts2=count3;
		LCD_goto(3,13);
		LCD_Text("S2:");
		LCD_Int(total_counts2);
	}
}

//------------------------------------
void game2_display_results()
{
	//Stop count1
	if(Player1_Button && step1==1 && count1<8001)
	{
		//Acknowledge button press
		beep();
		step1=2;
	}
	
	if(step1==2)
	{
		//Start count2 for player1
		count2=main_counter-count1;
		if(count2>8001)
		{
			count2=8001;
			game_restart();
		}
		LCD_goto(2,1);
		LCD_Text("C2: ");
		LCD_Int(count2);
		//Total counts for player1
		total_counts=count1+count2;
		LCD_goto(3,1);
		//S1==Sum1= count1+count2 for player 1
		LCD_Text("S1:");
		LCD_Int(total_counts);
	}
	if(Player2_Button && step1==2 && count2<8001)
	{
		//Acknowledge button press
		beep();
		step1=0;
	}
	
	if(step1==0)
	{
		if (total_counts<total_counts2)
		{
			LCD_goto(4,1);
			LCD_Text("Winner: Player 1");
			LED1_OFF;
		}
		
	}
	//Stop count3
	if(Player3_Button && step2==3 && count3<8001)
	{
		//Acknowledge button press
		beep();
		step2=4;
	}
	if(step2==4)
	{
		//Start count4 for player2.
		count4=main_counter-count3;
		if(count4>8001)
		{
			count4=8001;
			game_restart();
		}
		LCD_goto(2,13);
		LCD_Text("C4: ");
		LCD_Int(count4);
		//Total counts for player2
		total_counts2=count3+count4;
		LCD_goto(3,13);
		//S2==Sum2= count3+count4 for player 2;
		LCD_Text("S2:");
		LCD_Int(total_counts2);
	}
	if(Player4_Button && step2==4 && count4<8001)
	{
		//Acknowledge button press
		beep();
		step2=0;
	}
	if(step2==0)
	{
		if (total_counts2<total_counts)
		{
			LCD_goto(4,1);
			LCD_Text("Winner: Player 2");
			LED1_OFF;
		}
	}
	if(step1==0 && step2==0)
	{
		LED1_OFF;
	}
}

//------------------------------------
void game3()
{
	//Function for setting the number of players for game3
	game3_number_of_players();
	//while Start button is pressed, restart=1 or game_selector_restart=1		
	while(Start || restart || game_selector_restart)
	{
		game_reset();
		restart=0;
		game_selector_restart=0;
		start1=1;start2=1;start3=1;start4=1;
		LCD_goto(1,10);
		LCD_Text("Game 3");
		LCD_goto(2,10);
		LCD_Text("Players:");
		LCD_Int(game3_n_of_players);
	}
	//maximum count of the main counter= 8001 milliseconds
	if(main_counter>8001)
	{
		main_counter=8001;
		LED1_OFF;
	}
	game3_counters_on_off();
	game3_display_results();
}

//-------------------------------------
void game3_counters_on_off()
{
	COUNTER1_ON;
	if(start1==1)   count1=main_counter;
	if(start2==1)	count2=main_counter;
	if(start3==1)	count3=main_counter;
	if(start4==1)	count4=main_counter;

	//Stop player1 counter
	if(Player1_Button)
	{
		//Acknowledge button press
		beep();
		start1=0;
	}
	//Stop player2 counter
	if(Player2_Button)
	{
		//Acknowledge button press
		beep();
		start2=0;
	}
	//Stop player3 counter
	if(Player3_Button)
	{
		//Acknowledge button press
		beep();
		start3=0;
	}
	//If player3 button is pressed, do not stop player3 counter
	if(Player3_Button && game3_n_of_players==2) 
			start3=1;
						
	
	//Stop player4 counter
	if(Player4_Button)
	{
		//Acknowledge button press
		beep();
		start4=0;
	}
	//If player4 button is pressed, do not stop player4 counter
	if(Player4_Button && game3_n_of_players<4)
		
		start4=1;
				
	//If counters 1 to 4 are stopped, turn off LED1			
	if(start1==0 && start2==0 && start3==0 && start4==0)
		LED1_OFF;
	if(count1>8001)
	{
		count1=8001;
		game_restart();
		LCD_Clear();
	}
	if(count2>8001)
	{
		count2=8001;
		game_restart();
		LCD_Clear();
	}
	if(count3>8001 && game3_n_of_players>2)
	{
		count3=8001;
		game_restart();
		LCD_Clear();
	}
	if(count4>8001 && game3_n_of_players>3)
	{
		count4=8001;
		game_restart();
		LCD_Clear();
	}
}
//------------------------------------
void game3_display_results()
{
	LCD_goto(1,1);
	LCD_Int(count1);
	if (start1==0 && count1< count2 && count1<count3 && count1<count4 )
	
	{
		LCD_goto(3,10);
		LCD_Text("Winner:");
		LCD_goto(4,12);
		LCD_Text("Player1");
	}
	LCD_goto(2,1);
	LCD_Int(count2);

	if(start2==0 && count2< count1 && count2<count3 && count2<count4)
		
	{
		LCD_goto(3,10);
		LCD_Text("Winner:");
		LCD_goto(4,12);
		LCD_Text("Player2");
	}
	//-------------------------------------
	LCD_goto(3,1);
	LCD_Int(count3);
	//If number of players =2, do not show counter 3 on the LCD.
	if(game3_n_of_players==2)
	{
		LCD_goto(3,1);
		LCD_Text("     ");
	}
	if (start3==0 && count3 < count1 && count3<count2 && count3<count4 && game3_n_of_players>2)
	{
		LCD_goto(3,10);
		LCD_Text("Winner:");
		LCD_goto(4,12);
		LCD_Text("Player3");
	}
	//-------------------------------------
	LCD_goto(4,1);
	LCD_Int(count4);
	//If number of players=3, do not show counter 4 on the LCD.
	if(game3_n_of_players==2 || game3_n_of_players==3)
	{
		LCD_goto(4,1);
		LCD_Text("     ");
	}
	if(start4==0 && count4 < count1 && count4<count2 && count4<count3 && game3_n_of_players>3)
	{
		LCD_goto(3,10);
		LCD_Text("Winner:");
		LCD_goto(4,12);
		LCD_Text("Player4");
	}
	//-------------------------------------
	if (start1==0 && count1==count2 && count1<count3 && count1<count4)
	{
		LCD_goto(3,10);
		LCD_Text("Winners:");
		LCD_goto(4,8);
		LCD_Text("Players 1, 2");
	}
	//-------------------------------------
	if (start1==0 && count1==count3 && count3<count2 && count3<count4 )
	{
		LCD_goto(3,10);
		LCD_Text("Winners:");
		LCD_goto(4,8);
		LCD_Text("Players 1, 3");
	}
	if (start1==0 && count1==count4 && count1<count2 && count1<count3)
	{
		LCD_goto(3,10);
		LCD_Text("Winners:");
		LCD_goto(4,8);
		LCD_Text("Players 1, 4");
	}
	//-------------------------------------
	if (start1==0 && count1==count2 && count2==count3 && count3<count4)
	{
		LCD_goto(3,10);
		LCD_Text("Winners:");
		LCD_goto(4,6);
		LCD_Text("Players 1, 2, 3");
	}
	//-------------------------------------

	if (start2==0 && count2==count3 && count2<count1)
	{
		LCD_goto(3,10);
		LCD_Text("Winners:");
		LCD_goto(4,8);
		LCD_Text("Players 2, 3");
	}
	//-------------------------------------
	if (start2==0 && count2==count4 && count2<count1)
	{
		LCD_goto(3,10);
		LCD_Text("Winners:");
		LCD_goto(4,8);
		LCD_Text("Players 2, 4");
	}
	if (start3==0 && count3==count4 && count3<count1 && count3<count2)
	{
		LCD_goto(3,10);
		LCD_Text("Winners:");
		LCD_goto(4,8);
		LCD_Text("Players 3, 4");
	}

	if (start2==0 && count2==count3 && count3==count4 && count4<count1)
	{
		LCD_goto(3,10);
		LCD_Text("Winners:");
		LCD_goto(4,6);
		LCD_Text("Players 2,3, 4");
	}

	if (start1==0 && count1==count3 && count3==count4 && count4<count2)
	{
		LCD_goto(3,10);
		LCD_Text("Winners:");
		LCD_goto(4,6);
		LCD_Text("Players 1, 3, 4");
	}
}
//------------------------------------
void game3_number_of_players()
{
	//Press Play2_Button and START button
	//for setting  a two-player game.
	if(Player2_Button && Start)
	game3_n_of_players=2;
	
	
	//Press Play3_Button and START button
	//for setting  a three-player game.
	if(Player3_Button && Start )
	game3_n_of_players=3;
	
	
	//Press Play4_Button and START button
	//for setting a four-player game
	if(Player4_Button && Start )
	game3_n_of_players=4;
}
//------------------------------------
void display_n_o_players()
{
	switch(selector)
	{
		case 1:
		LCD_goto(2,10);
		LCD_Text("Game 1");
		
		LCD_goto(3,10);
		LCD_Text("Players:1");
		break;
		
		case 2:
		LCD_goto(2,10);
		LCD_Text("Game 2");
		
		LCD_goto(3,10);
		LCD_Text("Players:2");
		break;
		case 3:
		LCD_goto(3,10);
		LCD_Text("Game 3");
		break;
	}
}
//------------------------------------
void game_reset()
{
	begin:
	LED_flash();
	//If a player button is pressed too early
	//and before LED1 stops blinking, repeat the start cycle
	if(Player1_Button || Player2_Button ||Player3_Button ||Player4_Button)
	goto begin;
}
//------------------------------------
void LED_flash()
{
	LCD_Clear();
	LCD_goto(1,6);
	LCD_Text("Wait...");
	
	display_n_o_players();
	LED1_OFF;
	flash=0;
	//Returns a pseudo-random number in the range of 0 to RAND_MAX
	//here it returns random numbers 1 to 3
	random_number= (rand() % 3)+ 1;
	//Flash LED1 randomly 1 to 3 times
	for(flash>0;flash<random_number;flash++)
	{
		LED1_ON;
		_delay_ms(400);
		LED1_OFF;
		_delay_ms(400);
	}
	LED1_ON;
	beep();
	count1=0; count2=0;	count3=0; count4=0;total_counts=0;total_counts2=0;
	COUNTER1_OFF;
	main_counter=0;
	LCD_Clear();
}
//------------------------------------
void game_restart()
{
	if(restart==0)
	{
		restart==1;
		LED1_OFF;
		LCD_Clear();
		LCD_goto(1,3);
		LCD_Text("Timeout Error");
		LCD_goto(3,3);
		LCD_Text("Press Start Button");
		LCD_goto(4,5);
		LCD_Text("To Play Again");
		_delay_ms(1000);
	}
}
//------------------------------------
void beep()
{
	//Sounder beeps
	SOUND_ON;
	_delay_ms(50);
	SOUND_OFF;
}
//------------------------------------
/* Interrupt Service Routine of Timer2 */
ISR(TIMER2_OVF_vect)
{
	// Toggle PIND7 for sound generation
	PORTD ^= (1 << 7);
}
//------------------------------------
//Timer Counter 1 Compare Match A Interrupt Service Routine
ISR(TIMER1_COMPA_vect)
{
	main_counter++;
}
//------------------------------------
//End of program

